/*jQuery(document).ready(function($) {
    function updatePrice() {
        let totalPrice = 0;

        $('input[type="checkbox"]:checked').each(function() {
            totalPrice += parseFloat($(this).data('price')) || 0;
        });

        let discountPrice = totalPrice * 0.9;

        $('#total-price, #total-excluding-tax').text(totalPrice.toFixed(2) + " yen");
        $('#discount-price, #discount-excluding-tax').text(discountPrice.toFixed(2) + " yen");
    }

    $('.category-link').on('click', function(e) {
        e.preventDefault();

        var categorySlug = $(this).data('category');
        var propertyName = $('#propertyname').val();
        var buildingNumber = parseInt($('#buildingnumber').val(), 10);
        var remarks = $('#remarks').val();

        if (!buildingNumber || buildingNumber <= 0) {
            alert("Please enter a valid building number.");
            return;
        }

        $.ajax({
            url: ajaxurl,
            method: 'POST',
            data: {
                action: 'calculate_price',
                propertyname: propertyName,
                buildingnumber: buildingNumber,
                remarks: remarks,
                category: categorySlug,
            },
            success: function(response) {
                if (response.success) {
                    $('#category-posts').html(response.data.postsHtml);
                    updatePrice();

                    // Update the price and selected category name in the form-price-show section
                    $('#total-price').text(response.data.totalPrice + " yen");
                    $('#discount-price').text(response.data.discountPrice + " yen");
                    $('#total-excluding-tax').text(response.data.totalExcludingTax + " yen");
                    $('#discount-excluding-tax').text(response.data.discountExcludingTax + " yen");
                    $('#selected-category').text('Cupboard [Takara Standard] / Indoor laundry drying / Delivery box / Free wall / Gas dryer : ' + response.data.categoryName);
                } else {
                    alert('Error: ' + response.data);
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
            }
        });
    });

    $(document).on('change', 'input[type="checkbox"]', function() {
        updatePrice();
    });

    $(document).on('click', '.product-image', function() {
        $('#largeImage').attr('src', $(this).attr('src'));
        let newPrice = $(this).data('price');
        if (newPrice) {
            $('#total-price').text(newPrice + " yen");
        }
    });
	$('.black-box-product-image').click(function() {
        var newImage = $(this).attr('src'); // Get clicked image source
        $('#black-box-largeImage').attr('src', newImage); // Change the main image
    });
});
*/
/* new js */
jQuery(document).ready(function ($) {
    let selectedCategories = [];
    let selectedColors = {}; // カテゴリごとの選択した色を追跡するため

    // UIの価格表示を更新する
    function updatePriceDisplays(data) {
        $(".total-price").text(data.total_price.toLocaleString() + " 円 (税込)");
        $(".discount-price").text(data.discounted_price.toLocaleString() + " 円 (割引後)");
        $(".total-excluding-tax").text(data.total_excluding_tax.toLocaleString() + " 円 (税抜)");
        $(".discount-excluding-tax").text(data.discounted_excluding_tax.toLocaleString() + " 円 (割引後の税抜)");

        // 隠し価格フィールドを更新
        $("#total-price").text(data.total_price.toLocaleString() + " ");
        $("#total-excluding-tax").text(data.total_excluding_tax.toLocaleString() + " ");
        $("#discount-price").text(data.discounted_price.toLocaleString() + " ");
        $("#discount-excluding-tax").text(data.discounted_excluding_tax.toLocaleString() + " ");
    }

    // 選択したカテゴリ、建物番号、備考に基づいて価格を取得
    function fetchPrices() {
        let buildingNumber = parseInt($("#buildingnumber").val()) || 1;
        let remarks = $("#remarks").val();

        // AJAXリクエストの準備
        $.ajax({
            url: my_ajax_object.ajax_url,
            type: "POST",
            data: {
                action: "fetch_product_prices",
                categories: selectedCategories,
                buildingnumber: buildingNumber,
                remarks: remarks,
                colors: Object.values(selectedColors) // ここで選択した色を渡す
            },
            success: function (response) {
                if (response.success) {
                    updatePriceDisplays(response.data); // UIの価格表示を更新
                }
            }
        });
    }

    // カラーチェックボックスの変更を処理 (カテゴリごとに1色のみ)
    $(document).on('change', '.color-checkbox', function() {
        const categorySlug = $(this).closest('.category-view-verinent').find('.category-checkbox').val(); // 関連するカテゴリを取得
        const colorValue = $(this).val();

        // チェックボックスがチェックされた場合、同じカテゴリ内の他のものを非選択にする
        if ($(this).is(':checked')) {
            $(this).closest('.category-view-verinent').find('.color-checkbox').not(this).prop('checked', false);
            selectedColors[categorySlug] = colorValue; // カテゴリの選択した色を設定
        } else {
            delete selectedColors[categorySlug]; // チェックが外れた場合はカテゴリの色を削除
        }

        fetchPrices(); // 色の選択後に価格を取得
    });

    // チェックボックス変更時にカテゴリを追加/削除
    $(document).on("change", ".category-checkbox", function () {
        let category = $(this).val();

        if ($(this).is(":checked")) {
            selectedCategories.push(category);
        } else {
            selectedCategories = selectedCategories.filter(item => item !== category);
            delete selectedColors[category]; // カテゴリが非選択になったときに色をクリーンアップ
        }

        $("#selected-category").text(selectedCategories.join(" / "));
        fetchPrices(); // カテゴリの選択後に価格を取得
    });

    // リンクベースのカテゴリ選択を処理
    $(document).on("click", ".category-link", function (e) {
        e.preventDefault();
        let category = $(this).data("category");

        if (selectedCategories.includes(category)) {
            selectedCategories = selectedCategories.filter(item => item !== category);
            delete selectedColors[category]; // カテゴリが非選択になったときに色をクリーンアップ

            // カテゴリが非選択になったときは価格をリセット
            $(".total-price").text("0 円 (税込)");
            $(".discount-price").text("0 円 (割引後)");
            $(".total-excluding-tax").text("0 円 (税抜)");
            $(".discount-excluding-tax").text("0 円 (割引後の税抜)");
        } else {
            selectedCategories.push(category);
        }

        $("#selected-category").text(selectedCategories.join(" / "));
        
        if (selectedCategories.length > 0) {
            fetchPrices(); // カテゴリが選択されている場合にのみ価格を取得
        }
    });

    // 備考や建物番号の変更に基づいて価格を更新
    $("#buildingnumber, #remarks").on("input", function () {
        if (selectedCategories.length > 0) {
            fetchPrices(); // 建物番号や備考が変更されたときに価格を取得
        }
    });

    // PDF生成ボタンのための処理
    $(".button-pdf-generate").on("click", function (e) {
        e.preventDefault();

        if (selectedCategories.length === 0) {
            alert("少なくとも1つのカテゴリを選択してください。");
            return;
        }

        // URLのための値を準備
        let buildingNumber = $("#buildingnumber").val() || "指定なし"; // 空の時のデフォルト値
        let remarks = encodeURIComponent($("#remarks").val());
        let totalPrice = encodeURIComponent($(".total-price").text().replace(/ 円 \(税込\)/, "").replace(/,/g, ""));
        let discountPrice = encodeURIComponent($(".discount-price").text().replace(/ 円 \(税込\)/, "").replace(/,/g, ""));
        
        // 選択した色を含むPDF生成のためのURLを構築
        let pdfUrl = `/wp-content/themes/hello-elementor-child/generate-pdf.php?category=${encodeURIComponent(selectedCategories.join(","))}&buildingnumber=${encodeURIComponent(buildingNumber)}&remarks=${remarks}&total_price=${totalPrice}&discount_price=${discountPrice}&selected_colors=${encodeURIComponent(Object.values(selectedColors).join(","))}`;
        
        window.open(pdfUrl, "_blank");
    });
});

document.addEventListener("DOMContentLoaded", function () {
    document.querySelector(".wpcf7-form").addEventListener("submit", function (event) {
        event.preventDefault();

        const urlParams = new URLSearchParams(window.location.search);
        let pdfUrl = "/option-application-pdf.php?" + urlParams.toString();

        fetch(pdfUrl)
            .then(response => response.json())
            .then(data => {
                console.log("PDF Generated at:", data.pdf_url);

                let input = document.createElement("input");
                input.type = "hidden";
                input.name = "your-pdf";
                input.value = data.pdf_url;
                document.querySelector(".wpcf7-form").appendChild(input);

                document.querySelector(".wpcf7-form").submit();
            })
            .catch(error => console.error("Error Generating PDF:", error));
    });
});
