<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\SocialController;

// Home
Route::get('/', function () {
    return view('welcome');
});

// Dashboard (protected)
Route::get('/dashboard', function () {
    return view('dashboard', ['user' => Auth::user()]);
})->middleware('auth');

// Login & Logout
Route::get('/login', function () {
    return view('login');
})->name('login');

Route::get('/logout', function () {
    Auth::logout();
    return redirect('/');
});

// ==================
// Facebook Login
// ==================
Route::get('/auth/facebook', [SocialController::class, 'facebookRedirect']);
Route::get('/auth/facebook/callback', [SocialController::class, 'facebookCallback']);

// Facebook data deletion (still closure, since it's special)
Route::post('/facebook-data-deletion', function (Request $request) {
    $signedRequest = $request->input('signed_request');

    [$encodedSig, $payload] = explode('.', $signedRequest, 2);
    $data = json_decode(base64_decode(strtr($payload, '-_', '+/')), true);

    if (!empty($data['user_id'])) {
        \App\Models\User::where('facebook_id', $data['user_id'])->delete();
    }

    return response()->json([
        'url' => url('/deletion-status/' . uniqid()),
        'confirmation_code' => uniqid(),
    ], 200);
});

Route::get('/deletion-status/{code}', function ($code) {
    return "Your Facebook data deletion request (Code: {$code}) has been processed.";
});

// ==================
// LinkedIn Login
// ==================
Route::get('/auth/linkedin', [SocialController::class, 'redirectToLinkedin']);
Route::get('/auth/linkedin/callback', [SocialController::class, 'handleLinkedinCallback']);
