<?php

// namespace App\Http\Controllers\Auth;

// use App\Http\Controllers\Controller;
// use Illuminate\Support\Facades\Auth;
// use Laravel\Socialite\Facades\Socialite;
// use App\Models\User;
namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Str;
 
class SocialController extends Controller
{
    public function facebookRedirect() {
        return Socialite::driver('facebook')->redirect();
    }

    public function facebookCallback() {
        $fbUser = Socialite::driver('facebook')->user();
        $user = User::firstOrCreate(
            ['email' => $fbUser->getEmail()],
            ['name' => $fbUser->getName(), 'password' => bcrypt(str()->random(16))]
        );
        Auth::login($user);
        return redirect('/dashboard');
    }
 
    // Redirect to LinkedIn with OpenID scopes
    public function redirectToLinkedin()
    {
        return Socialite::driver('linkedin-openid')
            ->scopes(['openid', 'profile', 'email'])
            ->redirect();
    }
       public function handleLinkedinCallback()
    {
        try {
            $linkedinUser = Socialite::driver('linkedin-openid')->stateless()->user();

            // LinkedIn OpenID returns `sub` as ID
            $email = $linkedinUser->getEmail() ?? $linkedinUser->getId() . '@linkedin.local';

            $user = User::updateOrCreate(
                ['email' => $email],
                [
                    'name' => $linkedinUser->getName() ?? $linkedinUser->getNickname(),
                    'linkedin_id' => $linkedinUser->getId(),
                    'password' => bcrypt(Str::random(16)),
                ]
            );

            Auth::login($user);

            return redirect('/dashboard');

        } catch (\Exception $e) {
            return redirect('/login')->withErrors(['linkedin' => $e->getMessage()]);
        }
    }


}