jQuery(document).ready(function($) {

    function runTournamentAjax(paged = 1) {
        var formData = $('#tournament-filter-form').serializeArray(); // Use serializeArray for push
        formData.push({ name: 'paged', value: paged });

        $.ajax({
            url: itpl_ajax.ajax_url,
            type: 'POST',
            data: formData,
            success: function(response) {
                if (response.success) {
                    $('#tournament-results').html(response.data);
                } else {
                    $('#tournament-results').html('<p>No tournaments found.</p>');
                }
            },
            error: function() {
                $('#tournament-results').html('<p>Error loading tournaments.</p>');
            }
        });
    }

    // Prevent Enter key from submitting form
    $('#tournament-filter-form input').on('keypress', function(e) {
        if (e.which === 13) {
            e.preventDefault();  
        }
    });

    // Trigger AJAX on search input
    $('#tournament-filter-form input[name="s"]').on('input', function() {
        runTournamentAjax(); // default paged = 1
    });

    // Trigger AJAX on date change
    $('#tournament-filter-form input[name="date"]').on('change', function() {
        runTournamentAjax(); // default paged = 1
    });

    // Handle pagination click
    $(document).on('click', '.pagination-link', function(e) {
        e.preventDefault();
        var page = $(this).data('page');
        runTournamentAjax(page); // send correct page number
    });

});


// jQuery(document).ready(function($){
//     $('#tournament-filter-form input').on('input change', function(){
//         var formData = $('#tournament-filter-form').serialize();

//         $.ajax({
//             url: itpl_ajax.ajax_url,
//             method: 'POST',
//             data: formData,
//             beforeSend: function() {
//                 $('#tournament-results').html('<p>Loading...</p>');
//             },
//             success: function(response) {
//                 if (response.success) {
//                     $('#tournament-results').html(response.data);
//                 } else {
//                     $('#tournament-results').html('<p>No results found.</p>');
//                 }
//             }
//         });
//     });
// });
